 ; Ŀ
 ;   Bl - make two lines into a polyline box.                              
 ;   Copyright 1996, 2006 by Rocket Software Ltd.                          
 ;   Smiling is not a modified baring of the teeth - the two expressions   
 ;   are vaguely similar but have different origins.  Some breeds of dogs  
 ;   smile, but they bare only their front teeth.  Most people don't       
 ;   bare their canines when they smile, but do when they snarl.           
 ; 

 ; Ŀ
 ;   Subroutine Hitsp - see if two lines have an intersection which lies   
 ;   on one of the lines.                                                  
 ;   Arguments: the four endpoints.                                        
 ;   Returns T or nil.                                                     
 ; 
 (DEFUN HITSP (pa1 pa2 pb1 pb2 / inta)
  (and (setq inta (inters pa1 pa2 pb1 pb2 nil))
       (or (spitt inta pa1 pa2)
           (spitt inta pb1 pb2))))
 ; Ŀ
 ;   Hitsp end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Lastv - returns the ename of the last vertex of the        
 ;   polyline whose ename was passed as the sole argument.                 
 ; 
 (DEFUN LASTV (enam / goon next typp)
  (setq goon T)
  (while (and goon
              (setq typp (cdr (assoc 0 (entget (setq next (entnext enam)))))))
         (if (= typp "SEQEND")
             (setq goon ())
             (setq enam next)))
 enam)
 ; Ŀ
 ;   Lastv end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Okpol: see if an entity is can be made into a pline.       
 ;   In other words it must be a line, pline, arc or lwpline, and if       
 ;   it is either type of polyline it must not be closed.                  
 ;   Takes one argument, an entity name.                                   
 ;   Calls nothing.                                                        
 ;   Returns a list of the endpoints if it is okay, else nil.              
 ; 
 (DEFUN OKPOL (enam / entt eleva typ open ends)
  (setq entt (entget enam))
  (if (and (setq eleva (cdr (assoc 38 entt)))
           (not (equal eleva 0 0.00000000001)))
      (write-line (strcat "\n*Caution: entity is at elevation "
                          (rtos eleva) ".")))
  (setq typ (cdr (assoc 0 entt)))
  (if (and (assoc 70 entt)
           (/= 1 (logand 1 (cdr (assoc 70 entt)))))
      (setq open T))
  (cond ((= typ "ARC")
         (setq ends (vrtarc enam)))
        ((= typ "LINE")
         (setq ends (list (cdr (assoc 10 entt)) (cdr (assoc 11 entt)))))
        ((= typ "POLYLINE")
         (if open
             (setq ends (list (cdr (assoc 10 (entget (entnext enam))))
                              (cdr (assoc 10 (entget (lastv enam))))))
             (write-line "\n*That was a closed polyline.*")))
        ((= typ "LWPOLYLINE")
         (if open
             (setq ends (wendi enam))
             (write-line "\n*That was a closed polyline.*")))
        (T (write-line "\n*Can't join to that entity.*")))
 ends)
 ; Ŀ
 ;   Okpol end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Spitt: see if a point lies on a line.  Sucks in three      
 ;   arguments, the point and the two endpoints of the line, and returns   
 ;   T if the point is on the line and () otherwise.                       
 ; 
 (DEFUN SPITT (pa linp1 linp2 / ang1 p2 inter1)
 ; Ŀ
 ;   Find the line angle.                                                  
 ; 
  (setq ang1 (angle linp1 linp2))
 ; Ŀ
 ;   Find the endpoint of a theoretical line starting at pa and            
 ;   perpendicular to the line described by the two endpoint arguments.    
 ; 
  (setq p2 (polar pa (+ ang1 (/ pi 2)) 10))
 ; Ŀ
 ;   Now find the intersection of the two.                                 
 ; 
  (setq inter1 (inters linp1 linp2 pa p2))
 ; Ŀ
 ;   If the two intersect and the intersection is at pa, then pa is on     
 ;   the line.                                                             
 ; 
  (if (and inter1 (equal pa inter1 0.0000001)) T ()))
 ; Ŀ
 ;   Spitt end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Wendi: Find the endpoints of an LwPolyline.                
 ;   Takes one argument, the ename, returns a list of the endpoints.       
 ; 
 (DEFUN WENDI (enam / entt num sub tenlst)
  (setq entt (entget enam))
  (setq num 0)
  (while (setq sub (nth num entt))
         (if (= (car sub) 10)
             (setq tenlst (cons sub tenlst)))
         (setq num (1+ num)))
 (list (cdar tenlst) (cdr (last tenlst))))
 ; Ŀ
 ;   Wendi end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Vrtarc: Find the endpoints of an arc.                      
 ;   Takes one argument, the arc ename, returns a list of the endpoints.   
 ; 
 (DEFUN VRTARC (enam / arcent cent stangl endang radd end1 end2)
  (setq arcent (entget enam))
  (setq cent (cdr (assoc 10 arcent)))
  (setq stangl (cdr (assoc 50 arcent)))
  (setq endang (cdr (assoc 51 arcent)))
  (setq radd (cdr (assoc 40 arcent)))
  (setq end1 (polar cent stangl radd))
  (setq end2 (polar cent endang radd))
 (list end1 end2))
 ; Ŀ
 ;   Vrtarc end.                                                           
 ; 

 ; Ŀ
 ;   Bl.                                                                   
 ; 
 (DEFUN C:BL (/ snapp osno *error* enam1 ends enam2 ends2 vertx11 vertx12
                                      vertx21 vertx22 enam3 enam4 dista distb)
  (setvar "cmdecho" 0)
  (command ".undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (setq osno (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
 (defun *error* (shk /)
  (setvar "snapmode" snapp)
  (setvar "osmode" osno)
  (if (= (type enam1) 'ENAME) (redraw enam1 4))
  (if shk (write-line shk))
  (command ".undo" "end")
 (princ))
 ; Ŀ
 ;   Get some lines or other useable entities, get the endpoints.          
 ; 
  (if (and (setq enam1 (car (entsel "First line: ")))
           (setq ends (okpol enam1)))
      (progn
           (redraw enam1 3)
           (setq enam2 (car (entsel "\nSecond line: ")))
           (if (equal enam1 enam2)
               (write-line "\n*Those were the same entity.*")
               (setq ends2 (okpol enam2)))))
  (setq vertx11 (car ends))
  (setq vertx12 (cadr ends))
  (setq vertx21 (car ends2))
  (setq vertx22 (cadr ends2))
 ; Ŀ
 ;   If the lines are more-or-less at right angles there may be two        
 ;   configurations where the lines don't cross.  It might be interesting  
 ;   to decide in this case based on the minimum total end-to-end          
 ;   distance.                                                             
 ;   Note: there are two ways to draw two lines between the endpoints of   
 ;   two existing lines.  One gives two new lines which don't intersect,   
 ;   one produces two which cross.                                         
 ;   If the intersection of the two original lines lies in space then      
 ;   it is possible to draw the new lines crossing, if the intersection    
 ;   lies on one of the existing lines then there is no way draw the new   
 ;   ones so that they cross.                                              
 ;   Case 1: the two original segments intersect on a segment, so the new  
 ;   segments can't intersect, draw them so as to have the smallest        
 ;   combined length.                                                      
 ; 
  (if (hitsp vertx11 vertx12 vertx21 vertx22)
      (progn
           (setq dista (+ (distance vertx11 vertx21)
                          (distance vertx12 vertx22)))
           (setq distb (+ (distance vertx11 vertx22)
                          (distance vertx12 vertx21)))
           (if (> dista distb)
               (progn
                    (command ".line" vertx11 vertx22 "")
                    (setq enam3 (entlast))
                    (command ".line" vertx12 vertx21 "")
                    (setq enam4 (entlast)))
               (progn
                    (command ".line" vertx11 vertx21 "")
                    (setq enam3 (entlast))
                    (command ".line" vertx12 vertx22 "")
                    (setq enam4 (entlast)))))
 ; Ŀ
 ;   Case 2: the two original segments don't intersect on a segment, so    
 ;   the new segments may intersect, draw them so that they don't.         
 ; 
      (cond ((and ends ends2 (inters vertx11 vertx21 vertx12 vertx22 t))
             (command ".line" vertx11 vertx22 "")
             (setq enam3 (entlast))
             (command ".line" vertx12 vertx21 "")
             (setq enam4 (entlast)))
            ((and ends ends2)
             (command ".line" vertx11 vertx21 "")
             (setq enam3 (entlast))
             (command ".line" vertx12 vertx22 "")
             (setq enam4 (entlast)))))
 ; Ŀ
 ;   If there are two new segments, add them to the existing entities      
 ;   to make a single polyline.                                            
 ; 
  (if (and enam3 enam4)
      (if (member (cdr (assoc 0 (entget enam1))) '("POLYLINE" "LWPOLYLINE"))
          (command "pedit" enam1 "j" enam2 enam3 enam4 "" "")
          (command "pedit" enam1 "y" "j" enam2 enam3 enam4 "" "")))
  (*error* nil)
 (princ))